import { sub } from "./arithmetic.js";
import { is_negative, is_zero } from "./predicates.js";
export function eq(comparahend, comparator) {
    return comparahend === comparator || is_zero(sub(comparahend, comparator));
}
export function lt(comparahend, comparator) {
    return is_negative(sub(comparahend, comparator));
}
export function lte(comparahend, comparator) {
    return lt(comparahend, comparator) || eq(comparahend, comparator);
}
export function gt(comparahend, comparator) {
    return lt(comparator, comparahend);
}
export function gte(comparahend, comparator) {
    return gt(comparahend, comparator) || eq(comparahend, comparator);
}
