import { BIGINT_ZERO } from "./constants.js";
import { integer } from "./constructors.js";
import { eq } from "./relational.js";
export function is_big_float(big) {
    return (typeof big === "object"
        && typeof big.coefficient === "bigint"
        && Number.isSafeInteger(big.exponent));
}
export function is_number(token) {
    return !Number.isNaN(Number(token));
}
export function is_negative(big) {
    return big.coefficient < BIGINT_ZERO;
}
export function is_positive(big) {
    return big.coefficient >= BIGINT_ZERO;
}
export function is_zero(big) {
    return big.coefficient === BIGINT_ZERO;
}
export function is_integer(a) {
    return eq(a, integer(a));
}
