import { abs, add, ceil, div, exponentiation, floor, mul, neg, sqrt, sub } from "./arithmetic.js";
import { make, string } from "./constructors.js";
import { is_integer, is_negative, is_positive, is_zero } from "./predicates.js";
import { eq, gt, gte, lt, lte } from "./relational.js";
export class BigFloat {
    constructor(n) {
        this.dp = this.decimalPlaces;
        this.isNeg = this.isNegative;
        this.eq = this.equals;
        this.gt = this.greaterThan;
        this.gte = this.greaterThanOrEqualTo;
        this.lt = this.lessThan;
        this.lte = this.lessThanOrEqualTo;
        this.isInt = this.isInteger;
        this.isPos = this.isPositive;
        this.abs = this.absoluteValue;
        this.neg = this.negated;
        this.sqrt = this.squareRoot;
        this.div = this.dividedBy;
        this.sub = this.minus;
        this.add = this.plus;
        this.mul = this.times;
        this.pow = this.toPower;
        const { exponent, coefficient } = make(n);
        this.exponent = exponent;
        this.coefficient = coefficient;
    }
    decimalPlaces() { return -this.exponent; }
    isInteger() { return is_integer(this); }
    isNegative() { return is_negative(this); }
    isPositive() { return is_positive(this); }
    isZero() { return is_zero(this); }
    toString() { return string(this); }
    equals(y) { return eq(this, make(y)); }
    greaterThan(y) { return gt(this, make(y)); }
    greaterThanOrEqualTo(y) { return gte(this, make(y)); }
    lessThan(y) { return lt(this, make(y)); }
    lessThanOrEqualTo(y) { return lte(this, make(y)); }
    absoluteValue() { return new BigFloat(abs(this)); }
    negated() { return new BigFloat(neg(this)); }
    squareRoot() { return new BigFloat(sqrt(this)); }
    dividedBy(y) { return new BigFloat(div(this, make(y))); }
    minus(y) { return new BigFloat(sub(this, make(y))); }
    plus(y) { return new BigFloat(add(this, make(y))); }
    times(y) { return new BigFloat(mul(this, make(y))); }
    toPower(y) { return new BigFloat(exponentiation(this, make(y))); }
    ceil() { return new BigFloat(ceil(this)); }
    floor() { return new BigFloat(floor(this)); }
}
