"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gte = exports.gt = exports.lte = exports.lt = exports.eq = void 0;
const arithmetic_js_1 = require("./arithmetic.js");
const predicates_js_1 = require("./predicates.js");
function eq(comparahend, comparator) {
    return comparahend === comparator || predicates_js_1.is_zero(arithmetic_js_1.sub(comparahend, comparator));
}
exports.eq = eq;
function lt(comparahend, comparator) {
    return predicates_js_1.is_negative(arithmetic_js_1.sub(comparahend, comparator));
}
exports.lt = lt;
function lte(comparahend, comparator) {
    return lt(comparahend, comparator) || eq(comparahend, comparator);
}
exports.lte = lte;
function gt(comparahend, comparator) {
    return lt(comparator, comparahend);
}
exports.gt = gt;
function gte(comparahend, comparator) {
    return gt(comparahend, comparator) || eq(comparahend, comparator);
}
exports.gte = gte;
