"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TWO = exports.ONE = exports.EPSILON = exports.set_precision = exports.PRECISION = exports.ZERO = exports.BIGINT_TEN_MILLION = exports.BIGINT_TEN = exports.BIGINT_ONE = exports.BIGINT_ZERO = void 0;
const constructors_js_1 = require("./constructors.js");
exports.BIGINT_ZERO = BigInt("0");
exports.BIGINT_ONE = BigInt("1");
exports.BIGINT_TEN = BigInt("10");
exports.BIGINT_TEN_MILLION = BigInt("10000000");
exports.ZERO = Object.create(null);
exports.ZERO.coefficient = exports.BIGINT_ZERO;
exports.ZERO.exponent = 0;
Object.freeze(exports.ZERO);
exports.PRECISION = -4;
function set_precision(n) {
    n = Number(n);
    if (!Number.isInteger(n) || Number(n) >= 0) {
        throw Error("Only negative integers are allowed for precision.");
    }
    exports.PRECISION = n;
}
exports.set_precision = set_precision;
exports.EPSILON = constructors_js_1.make("0.0000000000000000000000000000000000000000000000001");
exports.ONE = constructors_js_1.make("1");
exports.TWO = constructors_js_1.make("2");
