"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BigFloat = void 0;
const arithmetic_js_1 = require("./arithmetic.js");
const constructors_js_1 = require("./constructors.js");
const predicates_js_1 = require("./predicates.js");
const relational_js_1 = require("./relational.js");
class BigFloat {
    constructor(n) {
        this.dp = this.decimalPlaces;
        this.isNeg = this.isNegative;
        this.eq = this.equals;
        this.gt = this.greaterThan;
        this.gte = this.greaterThanOrEqualTo;
        this.lt = this.lessThan;
        this.lte = this.lessThanOrEqualTo;
        this.isInt = this.isInteger;
        this.isPos = this.isPositive;
        this.abs = this.absoluteValue;
        this.neg = this.negated;
        this.sqrt = this.squareRoot;
        this.div = this.dividedBy;
        this.sub = this.minus;
        this.add = this.plus;
        this.mul = this.times;
        this.pow = this.toPower;
        const { exponent, coefficient } = constructors_js_1.make(n);
        this.exponent = exponent;
        this.coefficient = coefficient;
    }
    decimalPlaces() { return -this.exponent; }
    isInteger() { return predicates_js_1.is_integer(this); }
    isNegative() { return predicates_js_1.is_negative(this); }
    isPositive() { return predicates_js_1.is_positive(this); }
    isZero() { return predicates_js_1.is_zero(this); }
    toString() { return constructors_js_1.string(this); }
    equals(y) { return relational_js_1.eq(this, constructors_js_1.make(y)); }
    greaterThan(y) { return relational_js_1.gt(this, constructors_js_1.make(y)); }
    greaterThanOrEqualTo(y) { return relational_js_1.gte(this, constructors_js_1.make(y)); }
    lessThan(y) { return relational_js_1.lt(this, constructors_js_1.make(y)); }
    lessThanOrEqualTo(y) { return relational_js_1.lte(this, constructors_js_1.make(y)); }
    absoluteValue() { return new BigFloat(arithmetic_js_1.abs(this)); }
    negated() { return new BigFloat(arithmetic_js_1.neg(this)); }
    squareRoot() { return new BigFloat(arithmetic_js_1.sqrt(this)); }
    dividedBy(y) { return new BigFloat(arithmetic_js_1.div(this, constructors_js_1.make(y))); }
    minus(y) { return new BigFloat(arithmetic_js_1.sub(this, constructors_js_1.make(y))); }
    plus(y) { return new BigFloat(arithmetic_js_1.add(this, constructors_js_1.make(y))); }
    times(y) { return new BigFloat(arithmetic_js_1.mul(this, constructors_js_1.make(y))); }
    toPower(y) { return new BigFloat(arithmetic_js_1.exponentiation(this, constructors_js_1.make(y))); }
    ceil() { return new BigFloat(arithmetic_js_1.ceil(this)); }
    floor() { return new BigFloat(arithmetic_js_1.floor(this)); }
}
exports.BigFloat = BigFloat;
